/*
 * MovementControl.h
 *
 *  Created on: 06.12.2012
 *      Author: georg
 */

#ifndef MOVEMENTCONTROL_H_
#define MOVEMENTCONTROL_H_

#include <iostream>
#include <sstream>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <termios.h>
#include <linux/serial.h>

enum MC_axes_flag{
	MC_X_AXIS = 1,
	MC_Y_AXIS,
	MC_Z_AXIS
};

class MovementControl {
public:
	MovementControl();
	virtual ~MovementControl();

	int getComPortHandle();
	int getMaxPosition();
	int getMaxMovementSpeed();
	int getMaxRampValue();
	int getRampValue(MC_axes_flag axis);
	int getPosition(MC_axes_flag axis);
	int getVoltage();

	int setPosition(MC_axes_flag axis, int counter);

	int openComPort(const char* device);
	int closeComPort();

	int moveWithSpeed(MC_axes_flag axis ,int speed);
	int moveSingleStep(MC_axes_flag axis, int counter);
	int moveRelativeToPosition(MC_axes_flag axis, int speed, int counter);
	int moveAbsoluteToPosition(MC_axes_flag axis, int speed, int counter);

	int stopFast(MC_axes_flag axis);

	int changeRampValue(MC_axes_flag axis, int value);

	int sendToComPort(std::string message);
	int readAnswerValue(std::string message);
	std::string readAnswer(std::string message);

private:
	static const int maxPosition = 2000000;
	static const int maxMovementSpeed = 32767;
	static const int maxRampValue = 31;

	int errorCount;
	int comPortHandle;
	int position_x;
	int position_y;
	int position_z;
};

#endif /* MOVEMENTCONTROL_H_ */
